/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: bitset.h,v $
*	$Revision: 1.13 $
*	$Date: 2006/02/13 14:47:30 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Maneesh Khattri, Ivan Zapreev
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: Define a Bitset-For the satisfaction relation in MCC.
*	Uses: Definition of bitset - bitset.h
*/

#ifndef BITSET_H

#define BITSET_H

/*****************************************************************************
			STRUCTURE
name: bit
@member b: One Bit.
remark:
******************************************************************************/
typedef struct bit
{
	unsigned b: 1;
}bit;

/*****************************************************************************
			STRUCTURE
name		: bytes
@member bits	: A Unit of 32 bits.
remark		: 1. This has no relation to the structure 'bit'.
		  2. This structure has 32 bits although it is named bytes.
******************************************************************************/
typedef struct bytes
{
	unsigned bits :32;
}bytes;

/*****************************************************************************
			STRUCTURE
name		: bitset
@member n	: The number of bits in this bitset.
@member bytesp	: A pointer to an array of structure 'bytes'.
remark		:
******************************************************************************/
typedef struct bitset
{
	int n;
	struct bytes *bytesp;
}bitset;

/*This are the constant bits*/
static const bit BIT_ON = {1}, BIT_OFF = {0};

/*****************************************************************************
name		: get_new_bitset
role       	: get a new bitset.
@param     	: int n: indicates the size of the required bitset.
@return		: bitset *: returns a pointer to a new bitset.
remark 	        : A bitset is composed of an array of 32-bit unsigned integers.
******************************************************************************/
extern bitset * get_new_bitset(int);

/*****************************************************************************
name		: or
role       	: obtain the disjunction of two bitsets.
@param     	: bitset *a: One of the operands to the disjunction operation.
@param		: bitset *b: The second operand to the disjuction operation.
@return		: bitset *: returns a pointer to the result of disjunction.
remark 	        : size of the operands must be the same else a NULL pointer is
		  returned as the result.
******************************************************************************/
extern bitset * or(bitset *, bitset *);

/*****************************************************************************
name		: or_result
role       	: obtain the disjunction of two bitsets and put result in arg2.
@param     	: bitset *a: One of the operands to the disjunction operation.
@param		: bitset *b: The second operand to the disjunction operation.
******************************************************************************/
extern void or_result(bitset *a, bitset *result);

/*****************************************************************************
name		: xor
role       	: obtain the exclusive-or of two bitsets.
@param     	: bitset *a: One of the operands to the exclusive-or operation.
@param		: bitset *b: The second operand to the exclusive-or operation.
@return		: bitset *: returns a pointer to the result of exclusive-or
remark 	        : The size of the operands must be the same else a NULL pointer is returned as the result.
******************************************************************************/
extern bitset * xor(bitset *, bitset *);

/*****************************************************************************
name		: xor_result
role       	: obtain the xor of two bitsets and put result in arg2.
@param     	: bitset *a: One of the operands to the x-or operation.
@param		: bitset *b: The second operand to the x-or operation.
******************************************************************************/
extern void xor_result(bitset *a, bitset *result);

/*****************************************************************************
name		: and
role       	: obtain the conjunction of two bitsets.
@param     	: bitset *a: One of the operands to the conjunction operation.
@param		: bitset *b: The second operand to the conjunction operation.
@return		: bitset *: returns a pointer to the result of conjunction.
remark 	        : The size of the operands must be the same else a NULL pointer is returned as the result.
******************************************************************************/
extern bitset * and(bitset *, bitset *);

/*****************************************************************************
name		: and_result
role       	: obtain the conjunction of two bitsets and put result in arg2.
@param     	: bitset *a: One of the operands to the conjunction operation.
@param		: bitset *b: The second operand to the conjunction operation.
******************************************************************************/
extern void and_result(bitset *a, bitset *result);

/*****************************************************************************
name		: not
role       	: obtain the complement of a bitset.
@param     	: bitset *a: The operand to the complement operation.
@return		: bitset *: returns a pointer to the result of complement.
remark 	        :
******************************************************************************/
extern bitset * not(bitset *);

/*****************************************************************************
name		: not_result
role       	: obtain the conjunction of two bitsets and put result in arg2.
@param     	: bitset *result: One of the operands to the complement op.
******************************************************************************/
extern void not_result(bitset *result);

/*****************************************************************************
name		: get_bit_val
role       	: obtain the value of a specified bit of a bitset.
@param     	: bitset *a: One of the bits of this bitset is of interest.
@param		: int i: The position of the bit of interest in the bitset.
@param		: bit * (result by reference): The bit of interest is returned
		    	in this parameter.
@return		: int: indicates the success/failure of the get operation.
			 -1: invalid i, 1: success
remark 	        :
******************************************************************************/
extern int get_bit_val(bitset *, int i, bit *);

/*****************************************************************************
name		: set_bit_val
role       	: set the value of a specified bit of a bitset.
@param     	: bitset *a: One of the bits of this bitset is to be changed.
@param		: int i: The position of the bit of interest in the bitset.
@param		: bit * val: The new value for the bit of interest.
remark 	        :
******************************************************************************/
extern void set_bit_val(bitset *, int i, const bit *);

/*****************************************************************************
name		: print_bitset_states
role       	: used to print the position of the bits
		 in the given bitset whose value is 1.
@param     	: bitset *a: The bitset to be printed.
@return		: 
remark 	        :
******************************************************************************/
extern void print_bitset_states(bitset *);

/*****************************************************************************
name		: free_bitset
role       	: used to free the given bitset.
@param     	: bitset *a: The bitset to be freed.
@return		: 
remark 	        :
******************************************************************************/
extern void free_bitset(bitset *);

/*****************************************************************************
name		: fill_bitset_one
role       	: fills the given bitset with one.
@param     	: bitset *a: The bitset to be filled.
@return		: bitset *: returns a pointer to the result of the filling operation.
remark 	        :
******************************************************************************/
extern void fill_bitset_one(bitset *);

/*****************************************************************************
name		: is_bitset_zero
role       	: checks if the bitset contains only zeros.
@param     	: bitset *a: The bitset to be checked.
@return		: 0: bitset contains a non-zero, 1: bitset contains only zeros.
******************************************************************************/
extern int is_bitset_zero(bitset *);

/*****************************************************************************
name		: get_idx_next_non_zero
role       	: Get the Index of the next non-zero element.
@param     	: bitset *a: The bitset to be checked.
@param     	: int idx: The Present index.
@return		: next index.
******************************************************************************/
extern int get_idx_next_non_zero(bitset *, int);

/*****************************************************************************
name		: count_non_zero
role       	: count the number of non-zero elements in the given bitset.
@param     	: bitset *: The bitset to be checked.
@return		: the count.
******************************************************************************/
extern int count_non_zero(bitset *);

#endif
