/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: discretization.h,v $
*	$Revision: 1.5 $
*	$Date: 2006/02/13 14:47:30 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Maneesh Khattri
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: Discretization for CSRL - U.
*	Uses: DEF: bitset.h, sparse.h, label.h, runtime.h
*		LIB: bitset.c, sparse.c, label.c, runtime.c
*	Remarks : Discretization for CSRL - U.
*			  
*			  For discussion see:
*			  1. B.R. Haverkort, L. Cloth, H.Hermanns, J.-P. Katoen, C. Baier.
*			  Model Checking Performability Properties. DSN-2002, IEEE CS Press,
*			  pp. 103-112, 2002.
*			  2. M. Khattri and R. Pulungan. Model Checking Markov Reward Models
*			  with Impulse Rewards. M.S. Thesis. University of Twente. 2004.
*/

/*****************************************************************************
name		: discretization
role       	: solve t-r-bounded until formula in MRM using discretization.
@param		: int state: the starting state.
@param		: bitset *phi: satisfaction relation for phi formula.
@param		: bitset *psi: satisfaction relation for psi formula.
@param		: double m_time: sup I.
@param		: double m_reward: sup J.
@param		: double d_factor: d factor.
@param		: int: print.
@return		: double: result of the until formula for one state.
remark 	        : 
******************************************************************************/
extern double discretization(int, bitset *, bitset *, double, double, double, int);
