/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: help.h,v $
*	$Revision: 1.20 $
*	$Date: 2006/02/13 14:47:30 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Ivan Zapreev
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: This file contains Help Messages.
*/

#define HELP_MSG " help\t - display this help\n quit\t - exit the program\n print\t - print parameters\n\
 ssd_on\t - Turn on the steady-state detection in uniformization of bounded untill, for CSL logic\n\
 ssd_off - Turn off the steady-state detection in uniformization of bounded untill, for CSL logic\n\
 set *\t - Where * is one of the following:\n\
 \t\t error_bound R\t\t - Error Bound for all methods. \n\
 \t\t max_iter I\t\t - Number of Max Iterations for all methods. \n\
 \t\t overflow R\t\t - Overflow for the Fox-Glynn algorithm.\n\
 \t\t underflow R\t\t - Underflow for the Fox-Glynn algorithm.\n\
 \t\t method_path M\t\t - Method for path formulas.\n\
 \t\t method_steady M\t - Method for steady state formulas.\n\
 \t\t method_until_rewards MU - Method for time-reward-bounded until formula.\n\
 \t\t w R\t\t\t - The probability threshold for uniformization Qureshi-Sanders\n\
 \t\t d R\t\t\t - The discretization factor for state rewards\n\
 \t   Here:\n\
 \t\t I is a natural number.\n\
 \t\t R is a real value.\n\
 \t\t M is one of {gauss_jacobi,gauss_seidel}.\n\
 \t\t MU is one of {uniformization_sericola, uniformization_qureshi_sanders, discretization_tijms_veldman}.\n"


#define HELP_CSL_MSG " CSL logic formulas:\n\
	CONST =   ff | tt\n\
	R     =   'real number'\n\
	OP    =   > | < | <= | >=\n\
	SFL   =   CONST\n\
		| LABEL\n\
		| ! SFL\n\
		| SFL && SFL\n\
		| SFL || SFL\n\
		| ( SFL )\n\
		| S{ OP R }[ SFL ]\n\
		| P{ OP R }[ PFL ]\n\
	PFL   =   X SFL\n\
		| X[ R, R ] SFL\n\
		| SFL U SFL\n\
		| SFL U[ R, R ] SFL\n" HELP_MSG

#define HELP_PCTL_MSG " PCTL logic formulas:\n\
	CONST =   ff | tt\n\
	R     =   'real number'\n\
	OP    =   > | < | <= | >=\n\
	SFL   =   CONST\n\
		| LABEL\n\
		| ! SFL\n\
		| SFL && SFL\n\
		| SFL || SFL\n\
		| ( SFL )\n\
		| L{ OP R }[ SFL ]\n\
		| P{ OP R }[ PFL ]\n\
	PFL   =   X SFL\n\
		| SFL U SFL\n\
		| SFL U[ R, R ] SFL\n"  HELP_MSG

#define HELP_PRCTL_MSG " PRCTL logic formulas:\n\
	CONST =   ff | tt\n\
	R     =   'real number'\n\
	OP    =   > | < | <= | >=\n\
	SFL   =   CONST\n\
		| LABEL\n\
		| ! SFL\n\
		| SFL && SFL\n\
		| SFL || SFL\n\
		| ( SFL )\n\
		| E [ R, R] SFL \n\
		| E [n][ R, R] SFL \n\
		| C [n][ R, R] SFL \n\
		| Y [n][ R, R] SFL \n\
		| L{ OP R }[ SFL ]\n\
		| P{ OP R }[ PFL ]\n\
	PFL   =   X SFL\n\
		| SFL U SFL\n\
		| SFL U[ R, R ][ R, R ] SFL\n\
		| SFL U[ R, R ] SFL\n"  HELP_MSG		

#define HELP_CSRL_MSG " CSRL logic formulas:\n\
	CONST =   ff | tt\n\
	R     =   'real number'\n\
	OP    =   > | < | <= | >=\n\
	SFL   =   CONST\n\
		| LABEL\n\
		| ! SFL\n\
		| SFL && SFL\n\
		| SFL || SFL\n\
		| ( SFL )\n\
		| S{ OP R }[ SFL ]\n\
		| P{ OP R }[ PFL ]\n\
	PFL   =   X SFL\n\
		| X [R, R] SFL\n\
		| X [R, R][R, R] SFL\n\
		| SFL U SFL\n\
		| SFL U[ R, R ] SFL\n\
		| SFL U[ R, R ] [ R, R ] SFL\n"  HELP_MSG
