/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: runtime.h,v $
*	$Revision: 1.20 $
*	$Date: 2006/02/13 14:47:31 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Maneesh Khattri, Ivan Zapreev
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: Store global variable: state_space, labelling, result_bitset.
*	Uses: DEF: sparse.h, bitset.h, label.h, runtime.h
*		LIB: sparse.c, bitset.c, label.c, runtime.c
*		Definition of runtime - runtime.h
*/

#include "sparse.h"
#include "label.h"
#include "macro.h"

#ifndef RUNTIME_H

#define RUNTIME_H

#define CSL_MODE 0
#define PCTL_MODE 1
#define PRCTL_MODE 2
#define CSRL_MODE 3

#define GJ 11
#define GS 12
#define US 13  /* uniformization Sericola */
#define UQS 14 /* uniformization Qureshi & Sanders */
#define DTV 15 /* discretization Tijms & Veldman */

/*****************************************************************************
name		: get_impulse_rewards
role       	: get the value of impulse_rewards
@param     	: 
remark 	        : sparse *: impulse_rewards
******************************************************************************/
extern sparse * get_impulse_rewards();

/*****************************************************************************
name		: set_impulse_rewards
role       	: set the value of impulse_rewards
@param     	: sparse *: the impulse rewards
remark 	        : 
******************************************************************************/
extern void set_impulse_rewards(sparse *);

/*****************************************************************************
name		: get_w
role       	: get the value of w
@param     	: 
remark 	        : double: w
******************************************************************************/
extern double get_w();

/*****************************************************************************
name		: set_w
role       	: set the value of w
@param     	: double: w
remark 	        : 
******************************************************************************/
extern void set_w(double);


/*****************************************************************************
name		: get_d_factor
role       	: get the value of d
@param     	: 
remark 	        : double: d
******************************************************************************/
extern double get_d_factor();

/*****************************************************************************
name		: set_d_factor
role       	: set the value of d_factor
@param     	: double: _d_factor
remark 	        : 
******************************************************************************/
extern void set_d_factor(double _d_factor);

/*****************************************************************************
name		: get_max_iterations
role       	: get the value of max_iterations
@param     	: 
remark 	        : int: max_iterations
******************************************************************************/
extern int get_max_iterations();

/*****************************************************************************
name		: set_max_iterations
role       	: set the value of max_iterations
@param     	: int: max_iterations
remark 	        : 
******************************************************************************/
extern void set_max_iterations(int);

/*****************************************************************************
name		: get_underflow
role       	: get the value of underflow
@param     	: 
remark 	        : double: underflow
******************************************************************************/
extern double get_underflow();

/*****************************************************************************
name		: set_underflow
role       	: set the value of underflow
@param     	: double: underflow
remark 	        : 
******************************************************************************/
extern void set_underflow(double underflow);

/*****************************************************************************
name		: get_overflow
role       	: get overflow
@param     	: 
remark 	        : double: overflow
******************************************************************************/
extern double get_overflow();

/*****************************************************************************
name		: set_overflow
role       	: set the value of overflow
@param     	: double: overflow
remark 	        : 
******************************************************************************/
extern void set_underflow(double overflow);

/*****************************************************************************
name		: set_method_path
role       	: set method_path for global access.
@param     	: double: method_path
remark 	        : should be either GJ or GS
******************************************************************************/
extern void set_method_path(int);

/*****************************************************************************
name		: get_method_path
role       	: get method_path
@param     	: 
remark 	        : double: method_path
******************************************************************************/
extern double get_method_path();

/*****************************************************************************
name		: set_method_steady
role       	: set method_steady for global access.
@param     	: double: method_steady
remark 	        : should be either GJ or GS
******************************************************************************/
extern void set_method_steady(int _method_steady);

/*****************************************************************************
name		: get_method_steady
role       	: get method_steady
@param     	: 
remark 	        : double: method_steady
******************************************************************************/
extern double get_method_steady();

/*****************************************************************************
name		: set_method_until_rewards
role       	: set the method for the evaluation of time-reward-bounded until.
@param     	: int: the method.
remark 	        : 
******************************************************************************/
extern void set_method_until_rewards(int);

/*****************************************************************************
name		: get_method_until_rewards
role       	: globally access the result bitset
@return		: int: the method.
remark 	        : 
******************************************************************************/
extern int get_method_until_rewards();

/*****************************************************************************
name		: set_error_bound
role       	: set error_bound for global access.
@param     	: double: the error bound
remark 	        : 
******************************************************************************/
extern void set_error_bound(double);

/*****************************************************************************
name		: get_error_bound
role       	: get error_bound.
@param     	: 
remark 	        : double: the error bound
******************************************************************************/
extern double get_error_bound();

/**
* Set Rewards
*/
void setRewards(double * _pRewards);

/**
* Get Rewards
*/
double * getRewards();

/**
* Free memory
*/
void free_rewards();
/**
* This method returns the mode in which we runthe mcc tool
* It can be either CSL_MODE, PCTL_MODE, PRCTL_MODE so far.
*/
int getRunMode();

/**
* This method sets the mode in which we runthe mcc tool
* It can be either CSL_MODE, PCTL_MODE, PRCTL_MODE so far.
*/
int setRunMode(int _mode);

/*****************************************************************************
name		: set_state_space
role       	: set state space for global access using get_state_space.
@param     	: sparse *: the state space.
remark 	        : 
******************************************************************************/
extern void set_state_space(sparse *);

/*****************************************************************************
name		: get_state_space
role       	: globally access state space.
@return		: sparse *: returns a pointer to a sparse matrix (the state space).
remark 	        : 
******************************************************************************/
extern sparse * get_state_space();

/*****************************************************************************
name		: set_labeller
role       	: set labelling function for global access using get_labeller.
@param     	: labelling *: the labelling function.
remark 	        : 
******************************************************************************/
extern void set_labeller(labelling *);

/*****************************************************************************
name		: get_labeller
role       	: globally access labelling function.
@return		: labelling *: returns a pointer to the structure labelling.
remark 	        : 
******************************************************************************/
extern labelling *get_labeller();

/*****************************************************************************
name		: set_result_bitset
role       	: set result bitset for global access using get_result_bitset.
@param     	: bitset *: the result bitset.
remark 	        : 
******************************************************************************/
extern void set_result_bitset(bitset *);

/*****************************************************************************
name		: get_result_bitset
role       	: globally access the result bitset
@return		: bitset *: the result bitset.
remark 	        : 
******************************************************************************/
extern bitset * get_result_bitset();

/*****************************************************************************
name		: get_e
role       	: globally access row sums.
@return		: double *:2 the row sums.
remark 	        : 
******************************************************************************/
extern double * get_e();

/*****************************************************************************
name		: free_e
role       	: free the e matrix.
remark 	        : 
******************************************************************************/
extern void free_e();

/*****************************************************************************
name		: set_ssd_on
role       	: enable uniformization
remark 	    : for the regular CSL uniformization 
******************************************************************************/
void set_ssd_on();

/*****************************************************************************
name		: set_ssd_off
role       	: disable uniformization
remark 	    : for the regular CSL uniformization 
******************************************************************************/
extern void set_ssd_off();

/*****************************************************************************
name		: is_ssd_on
role       	: returns TRUE if steady-state detection is enabled, otherwise FALSE
remark 	    : for the regular CSL uniformization 
******************************************************************************/
extern BOOL is_ssd_on();

#endif
