/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: transient.h,v $
*	$Revision: 1.14 $
*	$Date: 2006/02/13 14:47:31 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Maneesh Khattri, Ivan Zapreev
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: : Perform Transient Analysis for CSL - X, U.
*	Uses: DEF: sparse.h, bitset.h, label.h, runtime.h, transient.h, foxglynn.h
*		LIB: sparse.c, bitset.c, label.c, runtime.c, transient.c, foxglynn.c
*/

/*****************************************************************************
name		: until
role       	: solve until formula.
@param		: bitset *phi: satisfaction relation for phi formula.
@param		: bitset *psi: satisfaction relation for psi formula.
@param		: float subi: sub I.
@param		: float supi: sup I.
@return		: double *: result of the until formula for all states.
remark 	        : 
******************************************************************************/
extern double * until(bitset *, bitset *, float, float);

/*****************************************************************************
name		: until_rewards
role       	: solve until formula with rewards.
@param		: bitset *phi: satisfaction relation for phi formula.
@param		: bitset *psi: satisfaction relation for psi formula.
@param		: float subi: sub I.
@param		: float supi: sup I.
@param		: float subj: sub J.
@param		: float supj: sup J.
@return		: double *: result of the until formula for all states.
remark 	        : 
******************************************************************************/
extern double * until_rewards(bitset *, bitset *, float, float, float, float);

/*****************************************************************************
name		: next
role       	: solve next formula.
@param		: bitset *phi: satisfaction relation for phi formula.
@param		: float subi: sub I.
@param		: float supi: sup I.
@return		: double *: result of the next formula for all states.
remark 	        : 
******************************************************************************/
extern double * next(bitset *, float, float);

/*****************************************************************************
name		: next_rewards
role       	: solve next_rewards formula.
@param		: bitset *phi: satisfaction relation for phi formula.
@param		: float subi: sub I.
@param		: float supi: sup I.
@param		: float subj: sub J.
@param		: float supj: sup J.
@return		: double *: result of the next formula with rewards for all states.
remark 	        : 
******************************************************************************/
extern double * next_rewards(bitset *, float, float, float, float);

/**
* Creates new R matrix and copies all the rows that belong to the pValidStates into it
* @param pStateSpace the initial matrix
* @param pP the new matrix to where to copy rows
* @param pValidStates the valid states i.e. ids of the rows to be copied
*                     this array contains the number of nodes as the first element
*/
extern void makeAbsorbingDTMC(const sparse *, sparse *, int *);


/*****************************************************************************
name		: ab_state_space
role       	: make certain states (not in n_absorbing) absorbing.
@param		: sparse *state_space: the state space
@param		: bitset *n_absorbing: not absorbing states.
@param		: double *lambda(ref.): return value of uniformizing rate(also q).
@param		: double *abse: return row_sums
@return		: sparse *: new sparse matrix with some states made absorbing.
remark 	        : makes states absorbing (in ab_state_space) by assigning pointers
		  to rows (in state_space) only for those rows which are not to be
		  made absorbing.
******************************************************************************/
extern sparse * ab_state_space(sparse * state_space, bitset *n_absorbing, double *lambda, double *abse, int *non_absorbing);
                              
/**************************pM->rows*********************************************
name		: free_abs
role       	: free absorbing sparse matrix, created by ab_state_space function
@param		: sparse *abs: the state space
remark 	    : It's row elements were copied as structures,
			  so the internal row (values structure) pointers refer to the original matrix
			  and thus should not be cleaned !!! 
******************************************************************************/
extern void free_abs(sparse * abs);
