%{
/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: la_etmcc2.l,v $
*	$Revision: 1.8 $
*	$Date: 2006/02/13 14:47:31 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Maneesh Khattri, Ivan Zapreev
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: This is a lexical analyzer for the logic PCTL/CSL/PRCTL/CSRL in MRMC.
*/

#include<stdio.h>
#include<stdlib.h>
#include "foxglynn.h"
#include "bitset.h"
#include "sparse.h"
#include "label.h"
#include "runtime.h"
#include "y.tab.h"
#define prc(name) name=='y'
char pr='n';
%}

let      [_a-zA-Z]
num      [0-9]
alnum    [_a-zA-Z0-9<>_^*+-=]
white    [ \t\n\r\b]
%%

({num}+|{num}+\.{num}*|{num}*\.{num}+)([eE][+-]?{num}+)?[fF]? {if(prc(pr)) printf("FCON  : %s \n" ,yytext); yylval.fval=atof(yytext); return FNUM;}
"("		{ if(prc(pr)) printf("LP : %s\n", yytext); return LP;}
")"		{ if(prc(pr)) printf("RP : %s\n",yytext); return RP;}
"{"		{ if(prc(pr)) printf("LC : %s\n",yytext); return LC;}
"}"		{ if(prc(pr)) printf("RC : %s\n",yytext); return RC;}
"["		{ if(prc(pr)) printf("LB : %s\n",yytext); return LB;}
"]"		{ if(prc(pr)) printf("RB : %s\n",yytext); return RB;}
">"		{ if(prc(pr)) printf("Gr : %s\n",yytext); return Gr;}
">="		{ if(prc(pr)) printf("GE : %s\n",yytext); return GE;}
"<"		{ if(prc(pr)) printf("Le : %s\n",yytext); return Le;}
"<="		{ if(prc(pr)) printf("LE : %s\n",yytext); return LE;}
","		{ if(prc(pr)) printf("COMMA : %s\n",yytext); return COMMA;}
"&&"		{ if(prc(pr)) printf("AND	   : %s\n",yytext); return AND;}
"||"		{ if(prc(pr)) printf("OR      : %s\n",yytext); return OR;}
"=>"		{ if(prc(pr)) printf("IMPLIES   : %s\n",yytext); return IMPLIES;}
"!"		{ if(prc(pr)) printf("COMPLEMENT   : %s\n",yytext); return COMPLEMENT;}
"print"		{ if(prc(pr)) printf("PRN   : %s\n",yytext); return PRN;}
"error_bound"	{ if(prc(pr)) printf("EB   : %s\n",yytext); return EB;}
"max_iter"	{ if(prc(pr)) printf("MI   : %s\n",yytext); return MI;}
"overflow"	{ if(prc(pr)) printf("OV   : %s\n",yytext); return OV;}
"underflow"	{ if(prc(pr)) printf("UN   : %s\n",yytext); return UN;}
"method_path"	{ if(prc(pr)) printf("MP   : %s\n",yytext); return MP;}
"method_steady"	{ if(prc(pr)) printf("MS   : %s\n",yytext); return MS;}
"gauss_jacobi"	{ if(prc(pr)) printf("GAJA   : %s\n",yytext); return GAJA;}
"gauss_seidel"	{ if(prc(pr)) printf("GASE   : %s\n",yytext); return GASE;}
"method_until_rewards" { if(prc(pr)) printf("MUR   : %s\n",yytext); return MUR;}
"uniformization_sericola" { if(prc(pr)) printf("USE   : %s\n",yytext); return USE;}
"uniformization_qureshi_sanders" { if(prc(pr)) printf("UQUSA   : %s\n",yytext); return UQUSA;}
"discretization_tijms_veldman" { if(prc(pr)) printf("DTIVE   : %s\n",yytext); return DTIVE;}
"set"		{ if(prc(pr)) printf("SET   : %s\n",yytext); return SET;}
"w"		{ if(prc(pr)) printf("WVAL   : %s\n",yytext); return WVAL;}
"d"		{ if(prc(pr)) printf("DIVAL   : %s\n",yytext); return DIVAL;}
"quit"		{ if(prc(pr)) printf("QUIT   : %s\n",yytext); return QUIT;}
"help"		{ if(prc(pr)) printf("HELP   : %s\n",yytext); return HELP;}
"ssd_on"		{ if(prc(pr)) printf("SSD_ON   : %s\n",yytext); return SSD_ON;}
"ssd_off"		{ if(prc(pr)) printf("SSD_OFF   : %s\n",yytext); return SSD_OFF;}
"tt"		{ if(prc(pr)) printf("TRUE   : %s\n",yytext); return TT;}
"ff"		{ if(prc(pr)) printf("FALSE   : %s\n",yytext); return FF;}
"S"		{ if(prc(pr)) printf("STEADY   : %s\n",yytext); return STEADY;}
"P"		{ if(prc(pr)) printf("TRANSIENT   : %s\n",yytext); return TRANSIENT;}
"L"		{ if(prc(pr)) printf("LF   : %s\n",yytext); return LF;}
"E"		{ if(prc(pr)) printf("EF   : %s\n",yytext); return EF;}
"C"		{ if(prc(pr)) printf("CF   : %s\n",yytext); return CF;}
"Y"		{ if(prc(pr)) printf("YF   : %s\n",yytext); return YF;}
"X"		{ if(prc(pr)) printf("NEXT   : %s\n",yytext); return NEXT;}
"U"		{ if(prc(pr)) printf("UNTIL   : %s\n",yytext); return UNTIL;}
{let}{alnum}*   { if(prc(pr)) printf("AP : %s %d\n",yytext, AP); yylval.sval=yytext; return AP;}
"\n"		{ if(prc(pr)) printf("NEWLINE\n"); return NEWLINE;}
{white}	    	{ if(prc(pr)) printf(" ");}
%%
