%{
/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: parser_etmcc2.y,v $
*	$Revision: 1.13 $
*	$Date: 2006/02/13 14:47:32 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Maneesh Khattri, Ivan Zapreev
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: This is a parser for the logic CSL/PCTL/PRCTL/CSRL in MCC.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "foxglynn.h"
#include "bitset.h"
#include "sparse.h"
#include "label.h"
#include "runtime.h"
#include "transient.h"
#include "steady.h"
#include "prctl.h"
#include "sys/types.h"
#include "help.h"

#define toprint 1 

extern int yylex(void);
%}
%union
{
	int ival;
	char *sval;
	float fval;
	double *dval;
	bitset *b;
};

%nonassoc <sval> AP
%nonassoc <fval> FNUM
%nonassoc LP RP LC RC LB RB Gr GE Le LE PRN EB OV UN MP MS COMMA COMPLEMENT QUIT SET STEADY GAJA GASE MI MUR USE UQUSA DTIVE
%nonassoc TRANSIENT NEXT  UNTIL SPC NEWLINE TT FF IMPLIES EF CF YF LF HELP SSD_ON SSD_OFF WVAL DIVAL

%left AND OR
%right NOT

%type <ival> mformula
%type <b> stateformula notstateformula bracedstateformula propositionstateformula steadystateformula transientstateformula lstateformula estateformula cstateformula ystateformula
%type <b> notformula formula bracedformula propositionformula steadyformula transientformula eformula cformula yformula lformula
%type <dval> pathformula untilformula nextformula
/*The following is for {||, &&, >, <, =>, <=}*/
%type <ival> connective comparator

%%
mformula		: stateformula NEWLINE
			{
				set_result_bitset($1);
				/*print_bitset_states($1);*/
				return 1;
			}
			| QUIT NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_result_bitset(b);
				return 0;
			}
			| PRN NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				
				print_runtime_info();
				
				set_result_bitset(b);
				return 1;
			}
			| SET EB FNUM NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_error_bound($3);
			
				set_result_bitset(b);
				return 1;
			}
			| SET MI FNUM NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				double mi = $3;
				int max_iterations = $3;
				if(mi<=1e+9)
					set_max_iterations(max_iterations);
				else
					printf("Max Iterations not changed:: Choose at most 1e+9\n");
			
				set_result_bitset(b);
				return 1;
			}
			| SET OV FNUM NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_overflow($3);
			
				set_result_bitset(b);
				return 1;
			}
			| SET WVAL FNUM NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_w($3);
			
				set_result_bitset(b);
				return 1;
			}
			| SET DIVAL FNUM NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_d_factor($3);
			
				set_result_bitset(b);
				return 1;
			}
			| SET UN FNUM NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_underflow($3);
			
				set_result_bitset(b);
				return 1;
			}
			| SET MP GAJA NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_method_path(GJ);
			
				set_result_bitset(b);
				return 1;
			}
			| SET MP GASE NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_method_path(GS);
			
				set_result_bitset(b);
				return 1;
			}
			| SET MS GAJA NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_method_steady(GJ);
			
				set_result_bitset(b);
				return 1;
			}
			| SET MS GASE NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_method_steady(GS);
			
				set_result_bitset(b);
				return 1;
			}
			| SET MUR USE NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_method_until_rewards(US);
			
				set_result_bitset(b);
				return 1;
			}
			| SET MUR UQUSA NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_method_until_rewards(UQS);
			
				set_result_bitset(b);
				return 1;
			}
			| SET MUR DTIVE NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				set_method_until_rewards(DTV);
			
				set_result_bitset(b);
				return 1;
			}
			| SSD_ON NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
                set_ssd_on();
				set_result_bitset(b);
				return 1;
			}
			| SSD_OFF NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
                set_ssd_off();
				set_result_bitset(b);
				return 1;
			}
			| HELP NEWLINE
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				const int mode = getRunMode();
				switch(mode)
				{
					case CSL_MODE:
						printf("%s",HELP_CSL_MSG);
						break;
					case PCTL_MODE:
						printf("%s",HELP_PCTL_MSG);
						break;
					case PRCTL_MODE:
						printf("%s",HELP_PRCTL_MSG);
						break;
					case CSRL_MODE:
						printf("%s",HELP_CSRL_MSG);
						break;
					default :
						printf("%s",HELP_MSG);
				}
				set_result_bitset(b);
				return 1;
			}
			;
stateformula		: notstateformula		{$$=$1;}
	    		| bracedstateformula		{$$=$1;}
	    		| propositionstateformula	{$$=$1;}
	    		| steadystateformula		{$$=$1;}
	    		| transientstateformula		{$$=$1;}
			| lstateformula			{$$=$1;}
			| estateformula			{$$=$1;}
			| cstateformula			{$$=$1;}
			| ystateformula			{$$=$1;}
	    		;
notstateformula		: notformula			{$$=$1;}
	       		| notformula connective stateformula 
			{
				switch($2)
				{
					case OR: $$ = or($1, $3); break;
					case AND: $$ = and($1, $3);break;
					case IMPLIES: $$ = or(not($1), $3);
				};
			}
	       		;
bracedstateformula	: bracedformula			{$$=$1;}
			| bracedformula connective stateformula
			{
				switch($2)
				{
					case OR: $$ = or($1, $3); break;
					case AND: $$ = and($1, $3);break;
					case IMPLIES: $$ = or(not($1), $3);
				};
			}
			;
propositionstateformula	: propositionformula 		{$$=$1;}
			| propositionformula connective stateformula
			{
				switch($2)
				{
					case OR: $$ = or($1, $3); break;
					case AND: $$ = and($1, $3); break;
					case IMPLIES: $$ = or(not($1), $3);
				};
			}
			;
steadystateformula	: steadyformula			{$$=$1;}
			| steadyformula connective stateformula
			{
				switch($2)
				{
					case OR: $$ = or($1, $3); break;
					case AND: $$ = and($1, $3);break;
					case IMPLIES: $$ = or(not($1), $3);
				};
			}
			;
transientstateformula	: transientformula		{$$=$1;}
			| transientformula connective stateformula
			{
				switch($2)
				{
					case OR: $$ = or($1, $3); break;
					case AND: $$ = and($1, $3); break;
					case IMPLIES: $$ = or(not($1), $3);
				};
			}
			;
lstateformula		: lformula			{$$=$1;}
			| lformula connective stateformula
			{
				switch($2)
				{
					case OR: $$ = or($1, $3); break;
					case AND: $$ = and($1, $3);break;
					case IMPLIES: $$ = or(not($1), $3);
				};
			}
			;
estateformula		: eformula		{$$=$1;}
			| eformula connective stateformula
			{
				switch($2)
				{
					case OR: $$ = or($1, $3); break;
					case AND: $$ = and($1, $3); break;
					case IMPLIES: $$ = or(not($1), $3);
				};
			}
			;
cstateformula		: cformula		{$$=$1;}
			| cformula connective stateformula
			{
				switch($2)
				{
					case OR: $$ = or($1, $3); break;
					case AND: $$ = and($1, $3); break;
					case IMPLIES: $$ = or(not($1), $3);
				};
			}
			;
ystateformula		: yformula		{$$=$1;}
			| yformula connective stateformula
			{
				switch($2)
				{
					case OR: $$ = or($1, $3); break;
					case AND: $$ = and($1, $3); break;
					case IMPLIES: $$ = or(not($1), $3);
				};
			}
			;
notformula		: COMPLEMENT formula	{$$=not($2);}
	  		;
formula			: notformula	{$$=$1;}
			| bracedformula {$$=$1;}
			| propositionformula {$$=$1;}
			| steadyformula {$$=$1;}
			| transientformula {$$=$1;}
			| lformula 	{$$=$1;}
			| eformula 	{$$=$1;}
			| cformula 	{$$=$1;}
			| yformula 	{$$=$1;}
			;
bracedformula		: LP stateformula RP		{$$=$2;}
			;
propositionformula	: TT  
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				fill_bitset_one(b);
				$$ = b;
			}
			| FF
			{
				labelling *labellin = get_labeller();
				bitset *b=get_new_bitset(labellin->ns); 
				$$ = b;
			}
			| AP
			{
				labelling *labellin = get_labeller();
				bitset *b; 
				b=get_label_bitset(labellin, $1);
				if(b==NULL)
					b=get_new_bitset(labellin->ns);
				$$=b;	
			}
			;
steadyformula		: STEADY LC comparator FNUM RC LB stateformula RB 
			{
				labelling *labellin = get_labeller();
				int i, size = labellin->ns;
				bitset *b=get_new_bitset(size);
				double *result = NULL;
				bit bi; 
				struct timeval tt1, tt2;bi.b = 1;
				const int mode = getRunMode();
				
				if( mode == CSL_MODE || mode == CSRL_MODE )
				{
					gettimeofday(&tt1, NULL);
					result = steady($7);
					gettimeofday(&tt2, NULL);
					printf("time to compute: %ld micro sec(s)\n",
						(tt2.tv_sec-tt1.tv_sec)*1000000+(tt2.tv_usec-tt1.tv_usec));
					
					if(toprint)
					{
						printf("Result: ");
						print_vec_double(size,result);
					}
					
					for(i=0;i<size;i++)
					{
						switch($3)
						{
							case Gr: if (result[i]>$4) set_bit_val(b,i,&bi);
								break;
							case GE: if (result[i]>=$4) set_bit_val(b,i,&bi);
								break;
							case Le: if (result[i]<=$4) set_bit_val(b,i,&bi);
								break;
							case LE: if (result[i]<$4) set_bit_val(b,i,&bi);
						};
					}
				}
				else
					printf("Only CSL/CSRL mode is valid for the S operator\n");
				free(result);
				$$ = b;
			}
			; 
transientformula	: TRANSIENT LC comparator FNUM RC LB pathformula RB
			{
				labelling *labellin = get_labeller();
				int i, size = labellin->ns;
				bitset *b=get_new_bitset(size);
				bit bi; bi.b=1;
				for(i=0;i<size;i++)
				{
					switch($3)
					{
						case Gr: if ($7[i]>$4) set_bit_val(b,i,&bi);
							break;
						case GE: if ($7[i]>=$4) set_bit_val(b,i,&bi);
							break;
						case Le: if ($7[i]<=$4) set_bit_val(b,i,&bi);
							break;
						case LE: if ($7[i]<$4) set_bit_val(b,i,&bi);
					};
				}
				free($7);
				$$ = b;
			}			
			; 
pathformula		: LP pathformula RP	{$$=$2;}
			| untilformula		{$$=$1;}
			| nextformula		{$$=$1;}
			;
untilformula		: stateformula UNTIL stateformula
			{
				int size = (get_state_space())->rows, j;
				struct timeval tt1, tt2;
				const int mode = getRunMode();
	        		gettimeofday(&tt1, NULL);
				if( mode == CSL_MODE || mode == PCTL_MODE)
					$$=until($1, $3, 0.0, 0.0);
				else if(mode == PRCTL_MODE||mode == CSRL_MODE)
					$$=until_rewards($1, $3, 0.0, 0.0, 0.0, 0.0);
			        gettimeofday(&tt2, NULL);
			printf("time to compute: %ld micro sec(s)\n", (tt2.tv_sec-tt1.tv_sec)*1000000+(tt2.tv_usec-tt1.tv_usec));
				if(toprint)
				{
					printf("Result: ");
					print_vec_double(size,$$);
				}
			}
			| stateformula UNTIL LB FNUM COMMA FNUM RB stateformula 
			{
				int size = (get_state_space())->rows, j;
				struct timeval tt1, tt2;
				const int mode = getRunMode();
	        		gettimeofday(&tt1, NULL);
				if( mode == CSL_MODE || mode == PCTL_MODE)
					$$=until($1, $8, $4, $6);
				else if(mode == PRCTL_MODE || mode==CSRL_MODE)
					$$=until_rewards($1, $8, $4, $6, 0.0, 0.0);
			        gettimeofday(&tt2, NULL);
			printf("time to compute: %ld micro sec(s)\n", (tt2.tv_sec-tt1.tv_sec)*1000000+(tt2.tv_usec-tt1.tv_usec));
				if(toprint)
				{
					printf("Result: ");
					print_vec_double(size,$$);
					//printf("4167: %1.15le\n",$$[4167]); //For cluster computing N=10, K=3
				}
			}
			| stateformula UNTIL LB FNUM COMMA FNUM RB LB FNUM COMMA FNUM RB stateformula 
			{
				/* Need modes for MRM and DTMRM */
				const int mode = getRunMode();
				struct timeval tt1, tt2;
				labelling *labellin = get_labeller();
				int j, size = labellin->ns;
	        		gettimeofday(&tt1, NULL);
				if(mode == PRCTL_MODE || mode == CSRL_MODE)
				{
					$$=until_rewards($1, $13, $4, $6, $9, $11);
					if(toprint)
					{
						printf("Result: ");
						print_vec_double(size,$$);
					}
				}
				else
				{
					printf("Formula is valid only in PRCTL/CSRL mode\n");
					$$=(double *)calloc(size, sizeof(double));
				}
			        gettimeofday(&tt2, NULL);
			printf("time to compute: %ld micro sec(s)\n", (tt2.tv_sec-tt1.tv_sec)*1000000+(tt2.tv_usec-tt1.tv_usec));
			}
			;
nextformula		: NEXT stateformula 
			{
				const int mode = getRunMode();
				int size = (get_state_space())->rows, j;
				if( mode == PCTL_MODE || mode == CSL_MODE )
				{
					$$=next($2, 0.0, 0.0);
				}
				else if( mode == PRCTL_MODE||mode == CSRL_MODE )
				{
					$$=next_rewards($2, 0.0, 0.0, 0.0, 0.0);
				}
				else
				{
					printf("Invalid mode for this formula\n");
					$$=(double *)calloc(size, sizeof(double));
				}
				if(toprint)
				{
					printf("Result: ");
					print_vec_double(size,$$);
				}
			}
			| NEXT LB FNUM COMMA FNUM RB stateformula 
			{
				const int mode = getRunMode();
				int size = (get_state_space())->rows, j;
				if( mode == CSL_MODE )
				{
					$$=next($7, $3, $5);
				}
				else if( mode == CSRL_MODE )
				{
					$$=next_rewards($7, $3, $5, 0.0, 0.0);
				}
				else
				{
					printf("Formula is valid only in CSL/CSRL mode\n");
					$$=(double *)calloc(size, sizeof(double));
				}
				if(toprint)
				{
					printf("Result: ");
					print_vec_double(size,$$);
				}
			}
			| NEXT LB FNUM COMMA FNUM RB LB FNUM COMMA FNUM RB stateformula
			{
				const int mode = getRunMode();
				int size = (get_state_space())->rows, j;
				if( mode == CSRL_MODE )
				{				
					$$=next_rewards($12, $3, $5, $8, $10);
				}
				else
				{
					printf("Formula is valid only in CSRL mode\n");
					$$=(double *)calloc(size, sizeof(double));
				}
				if(toprint)
				{
					printf("Result: ");
					print_vec_double(size,$$);
				}
			}
			;
lformula		: LF LC comparator FNUM RC LB stateformula RB 
			{	
				labelling *labellin = get_labeller();
				int i, size = labellin->ns;
				bitset *b=get_new_bitset(size);
				double *result = NULL;
				bit bi; 
				struct timeval tt1, tt2;bi.b = 1;
				const int mode = getRunMode();

				if( mode == PCTL_MODE || mode == PRCTL_MODE )
				{
					/* steady also directly solves p.(I-P)=0 for DMTC & DTMRM */
					gettimeofday(&tt1, NULL);
					result = steady($7);
					
					gettimeofday(&tt2, NULL);
					printf("time to compute: %ld micro sec(s)\n",
						(tt2.tv_sec-tt1.tv_sec)*1000000+(tt2.tv_usec-tt1.tv_usec));
					
					if(toprint)
					{
						printf("Result: ");
						print_vec_double(size,result);
					}
					
					for(i=0;i<size;i++)
					{
						switch($3)
						{
							case Gr: if (result[i]>$4) set_bit_val(b,i,&bi);
								break;
							case GE: if (result[i]>=$4) set_bit_val(b,i,&bi);
								break;
							case Le: if (result[i]<=$4) set_bit_val(b,i,&bi);
								break;
							case LE: if (result[i]<$4) set_bit_val(b,i,&bi);
						};
					}
				}
				else
					printf("L formula is not valid in this mode\n");
				free(result);
				$$ = b;
			}
			;
eformula		: EF LB FNUM COMMA FNUM RB LB stateformula RB 
			{
				labelling *labellin = get_labeller();
				int i, size = labellin->ns;
				bitset *b=get_new_bitset(size);
				double *result;
				const int mode = getRunMode();
								
				if( mode == PRCTL_MODE )
				{
					result = ef(0, $8);
					for(i=0;i<size;i++)
						if(result[i]>=$3 && result[i]<=$5)
							set_bit_val(b, i, &BIT_ON);
					if(toprint)
					{
						printf("Result: ");
						print_vec_double(size,result);
					}
					free(result);
				}
				else
					printf("E formula is valid only in PRCTL mode\n");
				$$ = b;
			}
			|    EF LB FNUM RB LB FNUM COMMA FNUM RB LB stateformula RB 
			{
				labelling *labellin = get_labeller();
				int i, size = labellin->ns;
				bitset *b=get_new_bitset(size);
				double *result;
				const int mode = getRunMode();
								
				if( mode == PRCTL_MODE )
				{
					result = ef((int)$3, $11);
					for(i=0;i<size;i++)
						if(result[i]>=$6 && result[i]<=$8)
							set_bit_val(b, i, &BIT_ON);
					if(toprint)
					{
						printf("Result: ");
						print_vec_double(size,result);
					}
					free(result);
				}
				else
					printf("E formula is valid only in PRCTL mode\n");
				$$ = b;
			}		
			; 
cformula		:CF LB FNUM RB LB FNUM COMMA FNUM RB LB stateformula RB 
			{
				labelling *labellin = get_labeller();
				int i, size = labellin->ns;
				bitset *b=get_new_bitset(size);
				double *result;
				const int mode = getRunMode();
								
				if( mode == PRCTL_MODE )
				{			
					result = cf((int)$3, $11);
					for(i=0;i<size;i++)
						if(result[i]>=$6 && result[i]<=$8)
							set_bit_val(b, i, &BIT_ON);
					if(toprint)
					{
						printf("Result: ");
						print_vec_double(size,result);
					}
					free(result);
				}
				else
					printf("C formula is valid only in PRCTL mode\n");
				$$ = b;
			}		
			; 
yformula		: YF LB FNUM RB LB FNUM COMMA FNUM RB LB stateformula RB 
			{
				labelling *labellin = get_labeller();
				int i, size = labellin->ns;
				bitset *b=get_new_bitset(size);
				double *result;
				const int mode = getRunMode();
								
				if( mode == PRCTL_MODE )
				{							
					result = yf((int)$3, $11);
					for(i=0;i<size;i++)
						if(result[i]>=$6 && result[i]<=$8)
							set_bit_val(b, i, &BIT_ON);
					if(toprint)
					{
						printf("Result: ");
						print_vec_double(size,result);
					}
					free(result);
				}
				else
					printf("Y formula is valid only in PRCTL mode\n");
				$$ = b;
			}		
			; 
connective		: AND	{$$=AND;}
			| OR	{$$=OR;}
			| IMPLIES {$$=IMPLIES;}
			;
comparator		: Gr 	{$$=Gr;}
			| GE	{$$=GE;}
			| Le	{$$=Le;}
			| LE	{$$=LE;}
			;
%%
yyerror(char *s)
{ printf("%s\n",s);}
yywrap()
{}
