/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: discretization.c,v $
*	$Revision: 1.13 $
*	$Date: 2006/02/13 14:47:32 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Maneesh Khattri
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: Discretization for CSRL - U.
*	Uses: DEF: bitset.h, sparse.h, label.h, runtime.h
*		LIB: bitset.c, sparse.c, label.c, runtime.c
*	Remarks: Discretization for CSRL - U.
*		SLOW setting FTSKN
*			  
*	For discussion see:
*	  1. B.R. Haverkort, L. Cloth, H.Hermanns, J.-P. Katoen, C. Baier.
*	  Model Checking Performability Properties. DSN-2002, IEEE CS Press,
*	  pp. 103-112, 2002.
*	  2. M. Khattri and R. Pulungan. Model Checking Markov Reward Models
*	  with Impulse Rewards. M.S. Thesis. University of Twente. 2004.
*	  3. L. Cloth, J.-P. Katoen, M. Khattri, R. Pulungan, Model Checking
*	  Markov Reward Models with Impulse Rewards, DSN-PDS-05.
*
*	This is too slow though. haven't had time to think of something better.
*/

# include "macro.h"
#ifdef MAC_OS
	# include <stdlib.h>
#else
	# include <malloc.h>
#endif
#include "bitset.h"
#include "sparse.h"
#include "label.h"
#include "runtime.h"

/*****************************************************************************
name		: discretization
role       	: solve t-r-bounded until formula in MRM using discretization.
@param		: int state: the starting state.
@param		: bitset *phi: satisfaction relation for phi formula.
@param		: bitset *psi: satisfaction relation for psi formula.
@param		: double m_time: sup I.
@param		: double m_reward: sup J.
@param		: double d_factor: d factor.
@param		: int: print.
@return		: double: result of the until formula for one state.
remark 	        : 
******************************************************************************/
double discretization(int state, bitset *phi, bitset *psi, double m_time, double m_reward, double d_factor, int print)
{
	sparse *r_matrix = get_state_space();
	sparse *rewi_matrix = get_impulse_rewards();
	double *e = get_e();
	double *rew_matrix = getRewards();	
	int rows = phi->n, idx1, idx2;
	bitset *valid_states = or(phi, psi);
	int valid_number = count_non_zero(valid_states);
	int R=(int)m_reward/d_factor, T=(int)m_time/d_factor;
	sparse *ftskO, *ftskN;
	int col, count, t, k, new_reward, found=0;
	double val, ret, total_prob=0.0, rate, ir=0.0;
	bit get1b, get2b;
	ftskO=init_matrix(rows, R);
	set_mtx_val(ftskO, state, (int)rew_matrix[state], 1/d_factor);
	for(t=2;t<=T;t++)
	{
		ftskN = init_matrix(rows, R);
		idx1 = -1;
		while((idx1=get_idx_next_non_zero(valid_states, idx1))!=-1)
		{
			get_bit_val(phi, idx1, &get1b); get_bit_val(psi, idx1, &get2b);
			count=0; col=idx1; found=get_mtx_diag_val(ftskO, idx1, &val);
			do
			{
				if(found!=0&&get2b.b)
					add_mtx_val(ftskN, idx1, col, val);
				else if(found!=0)
				{
					new_reward= col+rew_matrix[idx1];
					if(new_reward<=R)
						add_mtx_val(ftskN, idx1, new_reward, val*(1-e[idx1]*d_factor));
				}
			}while((found=get_mtx_next_val(ftskO, idx1, &col, &val, &count))!=0);
			idx2 = -1;

			while((idx2=get_idx_next_non_zero(valid_states, idx2))!=-1)
			{
				get_bit_val(phi, idx2, &get1b); get_bit_val(psi, idx2, &get2b);
				if (!get2b.b && get_mtx_val(r_matrix, idx2, idx1, &ret)!=0) /* maybe this is slow too */
				{
					if(rewi_matrix!=NULL) /* CANT HELP IT - FOR NOW */
						get_mtx_val(rewi_matrix, idx2, idx1, &ir);
					count=0; col=idx2; found=get_mtx_diag_val(ftskO, idx2, &val);
					do
					{
						new_reward= col+rew_matrix[idx2]+ir;
						if(found!=0&&new_reward<=R)
							add_mtx_val(ftskN, idx1, new_reward, val*ret*d_factor);
					}while((found=get_mtx_next_val(ftskO, idx2, &col, &val, &count))!=0);
				}
			}
		}
		free_mtx_sparse(ftskO);
		ftskO = NULL;
		ftskO=ftskN;
		ftskN=NULL;
	}
	idx1=-1;
	while((idx1=get_idx_next_non_zero(psi, idx1))!=-1)
	{
		count=0; col=idx1; found=get_mtx_diag_val(ftskO, idx1, &val);
		do
			if(found!=0)
				total_prob+=val*d_factor;
		while((found=get_mtx_next_val(ftskO, idx1, &col, &val, &count))!=0);
	}
	free_mtx_sparse(ftskO);
	ftskO = NULL;
	return total_prob;
}
