/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: runtime.c,v $
*	$Revision: 1.26 $
*	$Date: 2006/02/13 14:47:33 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Maneesh Khattri, Ivan Zapreev
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: Store global variable: state_space, labelling, result_bitset.
*	Uses: DEF: sparse.h, bitset.h, label.h, runtime.h
*		LIB: sparse.c, bitset.c, label.c, runtime.c
*		Definition of runtime - runtime.h
*/

# include "macro.h"
#ifdef MAC_OS
	# include <stdlib.h>
#else
	# include <malloc.h>
#endif
# include <stdio.h>
# include <stdlib.h>
# include <float.h>
# include "bitset.h"
# include "sparse.h"
# include "label.h"
# include "runtime.h"

static int mode = CSL_MODE;
//True if the steady-state detection is on
BOOL ssd_on = FALSE;

sparse *state_space = NULL;
sparse *impulse_rewards = NULL; /* allowed to be NULL, if not specified, for MRMs (continuous). */
labelling *labeller = NULL;
bitset *result_bitset = NULL;
double *e = NULL;

/*Rewards for DTRM*/
static double * pRewards = NULL;
double error_bound=1e-6;
int method_path=GJ, method_steady=GJ;
int method_until_rewards=DTV;
int max_iterations=1000000;
double un=DBL_MIN, ov=DBL_MAX;
double d_factor = (double)1/32.0;
double w = 1e-11;

/*****************************************************************************
name		: get_impulse_rewards
role       	: get the value of impulse_rewards
@param     	: 
remark 	        : sparse *: impulse_rewards
******************************************************************************/
sparse * get_impulse_rewards()
{
	return impulse_rewards;
}

/*****************************************************************************
name		: set_impulse_rewards
role       	: set the value of impulse_rewards
@param     	: sparse *: _impulse_rewards
remark 	        : 
******************************************************************************/
void set_impulse_rewards(sparse * _impulse_rewards)
{
	impulse_rewards=_impulse_rewards;
	set_method_until_rewards(UQS);
}

/*****************************************************************************
name		: get_w
role       	: get the value of w
@param     	: 
remark 	        : double: w
******************************************************************************/
double get_w()
{
	return w;
}

/*****************************************************************************
name		: set_w
role       	: set the value of w
@param     	: double: w
remark 	        : 
******************************************************************************/
void set_w(double _w)
{
	w=_w;
}


/*****************************************************************************
name		: get_d_factor
role       	: get the value of d
@param     	: 
remark 	        : double: d
******************************************************************************/
double get_d_factor()
{
	return d_factor;
}

/*****************************************************************************
name		: set_d_factor
role       	: set the value of d_factor
@param     	: double: _d_factor
remark 	        : 
******************************************************************************/
void set_d_factor(double _d_factor)
{
	d_factor=_d_factor;
}

/*****************************************************************************
name		: get_max_iterations
role       	: get the value of max_iterations
@param     	: 
remark 	        : int: max_iterations
******************************************************************************/
int get_max_iterations()
{
	return max_iterations;
}

/*****************************************************************************
name		: set_max_iterations
role       	: set the value of max_iterations
@param     	: int: max_iterations
remark 	        : 
******************************************************************************/
void set_max_iterations(int _max_iterations)
{
	max_iterations=_max_iterations;
}

/*****************************************************************************
name		: get_underflow
role       	: get the value of underflow
@param     	: 
remark 	        : double: underflow
******************************************************************************/
double get_underflow()
{
	return un;
}

/*****************************************************************************
name		: set_underflow
role       	: set the value of underflow
@param     	: double: underflow
remark 	        : 
******************************************************************************/
void set_underflow(double underflow)
{
	un=underflow;
}

/*****************************************************************************
name		: get_overflow
role       	: get overflow
@param     	: 
remark 	        : double: overflow
******************************************************************************/
double get_overflow()
{
	return ov;
}

/*****************************************************************************
name		: set_overflow
role       	: set the value of overflow
@param     	: double: overflow
remark 	        : 
******************************************************************************/
void set_overflow(double overflow)
{
	ov=overflow;
}

/*****************************************************************************
name		: set_method_path
role       	: set method_path for global access.
@param     	: double: method_path
remark 	        : should be either GJ or GS
******************************************************************************/
void set_method_path(int _method_path)
{
	method_path = _method_path;
}

/*****************************************************************************
name		: get_method_path
role       	: get method_path
@param     	: 
remark 	        : double: method_path
******************************************************************************/
double get_method_path()
{
	return method_path;
}

/*****************************************************************************
name		: set_method_steady
role       	: set method_steady for global access.
@param     	: double: method_steady
remark 	        : should be either GJ or GS
******************************************************************************/
void set_method_steady(int _method_steady)
{
	method_steady = _method_steady;
}

/*****************************************************************************
name		: set_method_until_rewards
role       	: set the method for the evaluation of time-reward-bounded until.
@param     	: int: the method.
remark 	        : 
******************************************************************************/
void set_method_until_rewards(int method_until_rew)
{
	method_until_rewards = method_until_rew;
}

/*****************************************************************************
name		: get_method_until_rewards
role       	: globally access the result bitset
@return		: int: the method.
remark 	        : 
******************************************************************************/
int get_method_until_rewards()
{
	return method_until_rewards;
}

/*****************************************************************************
name		: get_method_steady
role       	: get method_steady
@param     	: 
remark 	        : double: method_steady
******************************************************************************/
double get_method_steady()
{
	return method_steady;
}

/*****************************************************************************
name		: set_error_bound
role       	: set error_bound for global access.
@param     	: double: the error bound
remark 	        : 
******************************************************************************/
void set_error_bound(double _error_bound)
{
	error_bound = _error_bound;
}

/*****************************************************************************
name		: get_error_bound
role       	: get error_bound.
@param     	: 
remark 	        : double: the error bound
******************************************************************************/
double get_error_bound()
{
	return error_bound;
}

/**
* Set Rewards
*/
void setRewards(double * _pRewards)
{
	pRewards = _pRewards;
}

/**
* Get Rewards
*/
double * getRewards()
{
	return pRewards;
}

/**
* Free memory
*/
void free_rewards()
{
	if( pRewards ) free(pRewards);
}

/**
* This method returns the mode in which we runthe mcc tool
* It can be either CTMC_MODE or DTMC_MODE so far.
*/
int getRunMode()
{
	return mode;
}

/**
* This method sets the mode in which we runthe mcc tool
* It can be either CTMC_MODE or DTMC_MODE so far.
*/
int setRunMode(int _mode)
{
	mode = _mode;
}

/*****************************************************************************
name		: set_state_space
role       	: set state space for global access using get_state_space.
@param     	: sparse *: the state space.
remark 	        : 
******************************************************************************/
void set_state_space(sparse *space)
{
	state_space = space;
	set_sparse(state_space);
	e = get_row_sums();
}

/*****************************************************************************
name		: get_state_space
role       	: globally access state space.
@return		: sparse *: returns a pointer to a sparse matrix (the state space).
remark 	        : 
******************************************************************************/
sparse * get_state_space()
{
	return state_space;
}

/*****************************************************************************
name		: set_labeller
role       	: set labelling function for global access using get_labeller.
@param     	: labelling *: the labelling function.
remark 	        : 
******************************************************************************/
void set_labeller(labelling *labellin)
{
	labeller = labellin;
}

/*****************************************************************************
name		: get_labeller
role       	: globally access labelling function.
@return		: labelling *: returns a pointer to the structure labelling.
remark 	        : 
******************************************************************************/
labelling *get_labeller()
{
	return labeller;
}

/*****************************************************************************
name		: set_result_bitset
role       	: set result bitset for global access using get_result_bitset.
@param     	: bitset *: the result bitset.
remark 	        : 
******************************************************************************/
void set_result_bitset(bitset *b)
{
	result_bitset = b;
}

/*****************************************************************************
name		: get_result_bitset
role       	: globally access the result bitset
@return		: bitset *: the result bitset.
remark 	        : 
******************************************************************************/
bitset * get_result_bitset()
{
	return result_bitset;
}

/*****************************************************************************
name		: get_e
role       	: globally access row sums.
@return		: double *: the row sums.
remark 	        : 
******************************************************************************/
double * get_e()
{
	return e;
}

/*****************************************************************************
name		: free_e
role       	: free the e matrix.
remark 	        : 
******************************************************************************/
void free_e()
{
	free(e);
}

/*****************************************************************************
name		: set_ssd_on
role       	: enable uniformization
remark 	    : for the regular CSL uniformization 
******************************************************************************/
void set_ssd_on()
{
  ssd_on = TRUE;
}

/*****************************************************************************
name		: set_ssd_off
role       	: disable uniformization
remark 	    : for the regular CSL uniformization 
******************************************************************************/
void set_ssd_off()
{
  ssd_on = FALSE;
}

/*****************************************************************************
name		: is_ssd_on
role       	: returns TRUE if steady-state detection is enabled, otherwise FALSE
remark 	    : for the regular CSL uniformization 
******************************************************************************/
BOOL is_ssd_on()
{
   return ssd_on;
}

/*****************************************************************************
name		: print_runtime_info
role       	: this method is used to print the runtime settings of error
		  bounds, maximum number of iterations etc.
remark 	        : 
******************************************************************************/
void print_runtime_info()
{
	int mp  = get_method_path();
	int ms  = get_method_steady();
	int mur = get_method_until_rewards();
	printf(" Error Bound\t\t = %e\n", get_error_bound());
	printf(" Max Iterations\t\t = %ld\n", get_max_iterations());
	printf(" Overflow\t\t = %e\n", get_overflow());
	printf(" Underflow\t\t = %e\n", get_underflow());
	printf(" Probability Threshold\t = %e\n", get_w());
	printf(" Discretization factor\t = %e\n", get_d_factor());
	printf(" Uniformization, ssd\t = %s\n",(is_ssd_on() ? "ON":"OFF"));
	if(mp==GJ)
		printf(" Method Path\t\t = Gauss-Jacobi\n");
	if(mp==GS)
		printf(" Method Path\t\t = Gauss-Seidel\n");
	if(ms==GJ)
		printf(" Method Steady\t\t = Gauss-Jacobi\n");
	if(ms==GS)
		printf(" Method Steady\t\t = Gauss-Seidel\n");
	if(mur==US)
		printf(" Method Until Rewards\t\t = Uniformization-Sericola\n");
	if(mur==UQS)
		printf(" Method Until Rewards\t\t = Uniformization-Qureshi-Sanders\n");
	if(mur==DTV)
		printf(" Method Until Rewards\t = Discretization-Tijms-Veldman\n");
}
