/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: token.c,v $
*	$Revision: 1.6 $
*	$Date: 2006/02/13 14:47:33 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Maneesh Khattri
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: A simple tokenizer.
*	Uses: DEF: token.h
*/

# include "token.h"

/*****************************************************************************
name		: scan_number
role       	: get the next token: scan for a number.
@param		: char *src: the source string to be tokenized.
@param		: int *start: the index from which to commence search for a token in
		  	 the source string.
@param		: char *token: the token in which the new token is to be put.
@param		: int *idx: the index from which to commence adding in the token.
remark 	        : If while scanning an alphabet is encountered then scan for a
		  string subsequently.
******************************************************************************/
int scan_number(char *src, int *start, char *token, int *idx)
{
	int key = NUMBER;
while(*idx<MAXTOKENSIZE && isNumeric(src[*start]) && src[*start]!=' '&&src[*start]!='\t'&&src[*start]!='\n'&&src[*start]!='\0')
		token[(*idx)++] = src[(*start)++];
	if(!isNumeric(src[*start]) && src[*start]!=' '&&src[*start]!='\t'&&src[*start]!='\n'&&src[*start]!='\0')
	{
		key = ALPHANUMERIC;
		while(*idx<MAXTOKENSIZE && src[*start]!=' '&&src[*start]!='\t'&&src[*start]!='\n'&&src[*start]!='\0')
			token[(*idx)++] = src[(*start)++];
	}
	return key;
}

/*****************************************************************************
name		: scan_string
role       	: get the next token: scan for a string.
@param		: char *src: the source string to be tokenized.
@param		: int *start: the index from which to commence search for a token in
		  	 the source string.
@param		: char *token: the token in which the new token is to be put.
@param		: int *idx: the index from which to commence adding in the token.
remark 	        : 
******************************************************************************/
int scan_string(char *src, int *start, char *token, int *idx)
{
	int key = ALPHANUMERIC;
	while(*idx<MAXTOKENSIZE && src[*start]!=' '&&src[*start]!='\t'&&src[*start]!='\n'&&src[*start]!='\0')
		token[(*idx)++] = src[(*start)++];
	return key;
}

/*****************************************************************************
name		: get_next_token
role       	: get the next token.
@param		: char *src: the source string to be tokenized.
@param		: int *start: the index from which to commence search for a token in
		  	 the source string.
@param		: char *token: the token in which the new token is to be put.
remark 	        : 
******************************************************************************/
int get_next_token(char *src, int *start, char *token)
{
	int idx=0, key;
	while((src[*start]==' '||src[*start]=='\t')&&src[*start]!='\n'&&src[*start]!='\0')
		(*start)++;
	if(isNumeric(src[*start])) key = scan_number(src,start,token,&idx);
	else key = scan_string(src,start,token,&idx);
	token[idx]='\0';
	if(idx==0) key=EOL;
	return key;
}

