/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: test_bitset.c,v $
*	$Revision: 1.2 $
*	$Date: 2006/02/12 15:06:31 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Joost-Pieter Katoen, Maneesh Khattri, Ivan Zapreev, Tim Kemna
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: This is for testing the bitset only.
*	Uses: Definition of bitset - bitset.h
*/

# include "bitset.h"
/*
NOTE: THE TESTS IN THIS FILE SHOULD NOT FAIL. IF ONE OF THE
TESTS FAILS - SOMETHING'S REALLY WRONG.

IN CONTRAST TO THE TESTS HERE IN PRACTICE SOME INVOCATIONS
CAN FAIL DUE TO SPURIOUS INPUTS PROVIDED THAT THE TESTS HERE
WERE SUCCESSFUL. CONSEQUENTLY IT IS NECESSARY TO CHECK FOR
SPURIOUS INPUTS IN PRACTICAL SCENARIOS.
*/

/* this is for testing the bitset only*/
test()
{
	bitset *a = get_new_bitset(38), *b = get_new_bitset(38), *c;
	bit res, get1;
	/* test set/get */
	printf("Testing set/get\n");
	res.b=1;
	set_bit_val(a,31,&res);
	get_bit_val(a,31,&get1);
	printf("a.val[31]=%d\n", get1.b);
	set_bit_val(a,34,&res);
	get_bit_val(a,34,&get1);
	printf("a.val[34]=%d\n", get1.b);
	set_bit_val(a,35,&res);
	get_bit_val(a,35,&get1);
	printf("a.val[35]=%d\n",get1.b);
	print_bitset_states(a);
	printf("count a: %d\n", count_non_zero(a));
	set_bit_val(b,0,&res);
	get_bit_val(b,0,&get1);
	printf("b.val[0]=%d\n",get1.b);
	set_bit_val(b,31,&res);
	get_bit_val(b,31,&get1);
	printf("b.val[31]=%d\n",get1.b);
	set_bit_val(b,37,&res);
	get_bit_val(b,37,&get1);
	printf("b.val[37]=%d\n",get1.b);
	print_bitset_states(b);
	printf("count b: %d\n", count_non_zero(b));
	
	/*test or*/
	printf("Testing Or\n");
	c = or(a,b);
	get_bit_val(c,0,&get1);
	printf("c.val[0]=%d\n",get1.b);
	get_bit_val(c,31,&get1);
	printf("c.val[31]=%d\n",get1.b);
	get_bit_val(c,37,&get1);
	printf("c.val[37]=%d\n",get1.b);
	get_bit_val(c,1,&get1);
	printf("c.val[1]=%d\n",get1.b);
	print_bitset_states(c);
	printf("count c: %d\n", count_non_zero(c));

	/*test and*/
	printf("Testing And\n");
	c = and(a,b);
	get_bit_val(c,0,&get1);
	printf("c.val[0]=%d\n",get1.b);
	get_bit_val(c,31,&get1);
	printf("c.val[31]=%d\n",get1.b);
	get_bit_val(c,37,&get1);
	printf("c.val[37]=%d\n",get1.b);
	get_bit_val(c,1,&get1);
	printf("c.val[1]=%d\n",get1.b);
	print_bitset_states(c);
	printf("count c: %d\n", count_non_zero(c));
}

main(){test();}
