/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: test_lab_reader.c,v $
*	$Revision: 1.3 $
*	$Date: 2006/02/12 15:06:31 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Joost-Pieter Katoen, Maneesh Khattri, Ivan Zapreev, Tim Kemna
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: Tests the label file reading
*/

# include <stdio.h>
# include <stdlib.h>
# include <malloc.h>
# include "bitset.h"
# include "label.h"
# include "read_lab_file.h"

/*test bit values*/
void test_label(labelling *labellin, int nstates, char* lab)
{
	int i;	
	bit get1;

	for( i=0; i<nstates; i++ )
	{
		get_bit_val(get_label_bitset(labellin,lab),i,&get1);
		printf("labellin[\"%s\"][%d]=%d\n",lab,i,get1.b);
	}
}

/* works only with the test file */
void print_test_labellin(labelling *labellin, int nstates)
{
	int i;	

	/*test input of labels*/
	for( i=0; i<labellin->n; i++ )
		printf("Label[%d]=%s\n",i,labellin->label[i]);
		
	
	for( i=0; i<labellin->n; i++ )
		test_label(labellin,nstates,labellin->label[i]);
}

main(int argc, char* argv[])
{
	labelling *labellin=NULL;
	int nstates = atoi(argv[1]);

	if(argc==3)
	{
		labellin = read_lab_file(nstates, argv[2]);
		print_test_labellin(labellin, nstates);
	}
}
