/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: test_label.c,v $
*	$Revision: 1.2 $
*	$Date: 2006/02/12 15:06:31 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Joost-Pieter Katoen, Maneesh Khattri, Ivan Zapreev, Tim Kemna
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: This is for testing the label only.
*	Uses: Definition of label - label.h
*
*	NOTE: THE TESTS IN THIS FILE SHOULD NOT FAIL. IF ONE OF THE
*	TESTS FAILS - SOMETHING'S REALLY WRONG.
*
*	IN CONTRAST TO THE TESTS HERE IN PRACTICE SOME INVOCATIONS
*	CAN FAIL DUE TO SPURIOUS INPUTS PROVIDED THAT THE TESTS HERE
*	WERE SUCCESSFUL. CONSEQUENTLY IT IS NECESSARY TO CHECK FOR
*	SPURIOUS INPUTS IN PRACTICAL SCENARIOS.
*/

# include "bitset.h"
# include "label.h"

test()
{
	int i;
	bit get1,bb,c;
	bitset *bitset, *new_bitset;
	labelling *a, *b;
	/*check if labels are put in label*/
	printf("check if labels are put in labelling\n");
	a = get_new_label(5,5);
	add_label(a, "a");
	add_label(a, "b");
	add_label(a, "c");
	add_label(a, "d");
	add_label(a, "e");
	for(i=0;i<5;i++) printf("Label[%d]=%s\n",i,a->label[i]);

	/*check if labels are put in labelling in ordered fashion*/
	printf("check if labels are put in labelling in ordered fashion\n");
	b = get_new_label(5,5);
	add_label(b, "d");
	add_label(b, "b");
	add_label(b, "e");
	add_label(b, "c");
	add_label(b, "a");
	for(i=0;i<5;i++) printf("Label[%d]=%s\n",i,b->label[i]);
	
	/*check if states are assigned to labels one-by-one properly*/
	printf("check if states are assigned to labels one-by-one properly\n");
	set_label_bit(a,"a",0);
	set_label_bit(a,"a",1);
	set_label_bit(a,"e",4);
	set_label_bit(a,"e",3);
	set_label_bit(a,"e",2);

	print_bitset_states(get_label_bitset(a,"a"));
	print_bitset_states(get_label_bitset(a,"e"));

	
	/*check if states are assigned to labels (using bitset directly) properly*/
	printf("check if states are assigned to labels (using bitset directly) properly\n");
	new_bitset = get_new_bitset(5);
	bb.b = 1;

	set_bit_val(new_bitset, 1, &bb);

	add_label_bitset(b,"a",new_bitset);

	c.b = 1;

	set_bit_val(new_bitset, 4, &c);

	add_label_bitset(b,"e",new_bitset);

	print_bitset_states(get_label_bitset(b,"a"));
	print_bitset_states(get_label_bitset(b,"b"));
	print_bitset_states(get_label_bitset(b,"e"));
	
	/*free labelling*/
	free_labelling(a);
	free_labelling(b);
	free_bitset(new_bitset);
}

main(){test();}
