/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: test_omega.c,v $
*	$Revision: 1.3 $
*	$Date: 2006/02/12 15:06:31 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Joost-Pieter Katoen, Maneesh Khattri, Ivan Zapreev, Tim Kemna
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: Experiments from  M.C. Diniz, E. de Souza e Silva, H. Richard Gail.
*		Calculating the distribution of a linear combination of uniform order statistics.
*		Informs Journal on Computing 14(2), 2002.
*/

# include <stdio.h>
# include "bitset.h"
# include "uniformization_qureshi_sanders.h"

/*
My Results:
**************Result 1************
r_dash=1.5, val=1.000000e+00
r_dash=2.0, val=1.000000e-00
r_dash=2.5, val=1.000000e-00
r_dash=3.0, val=1.000000e-00
r_dash=3.5, val=9.999985e-01
r_dash=4.0, val=9.998328e-01
r_dash=4.5, val=9.936874e-01
r_dash=5.0, val=9.149632e-01
r_dash=5.5, val=5.858082e-01
r_dash=6.0, val=1.668740e-01
**********************************
**************Result 2************
r_dash=2, val=1.000000e+00
r_dash=3, val=1.000000e-00
r_dash=4, val=9.999962e-01
r_dash=5, val=9.854054e-01
r_dash=6, val=4.486271e-01
r_dash=7, val=6.311401e-03
r_dash=8, val=1.358614e-07
r_dash=9, val=0.000000e+00
**********************************
**************Result 3************
r_dash=2, val=1.000000e+00
r_dash=3, val=1.000000e+00
r_dash=4, val=1.000000e+00
r_dash=5, val=9.999994e-01
r_dash=6, val=3.842441e-01
r_dash=7, val=1.208332e-08
r_dash=8, val=0.000000e+00
r_dash=9, val=0.000000e+00
**********************************
----->>> Achieved accuracy is less than that achieved in the paper.
*/

int main(int argc, char * argv[])
{
	double dsr1[]={10,7,5,3,0};
	double dsr2[]={10,9.5,5,4,3,0};
	double dsr3[]={10,9.5,5,4,3,0};

	int k1[]={10,15,10,10,6};
	int k2[]={10,15,10,10,10,6};
	int k3[]={50,75,50,50,50,30};

	printf("**************Result 1************\n");
	printf("r_dash=1.5, val=%e\n", 1-omega(k1,1.5,4,5,dsr1));
	printf("r_dash=2.0, val=%e\n", 1-omega(k1,2.0,4,5,dsr1));
	printf("r_dash=2.5, val=%e\n", 1-omega(k1,2.5,4,5,dsr1));
	printf("r_dash=3.0, val=%e\n", 1-omega(k1,3.0,3,5,dsr1));
	printf("r_dash=3.5, val=%e\n", 1-omega(k1,3.5,3,5,dsr1));
	printf("r_dash=4.0, val=%e\n", 1-omega(k1,4.0,3,5,dsr1));
	printf("r_dash=4.5, val=%e\n", 1-omega(k1,4.5,3,5,dsr1));
	printf("r_dash=5.0, val=%e\n", 1-omega(k1,5.0,2,5,dsr1));
	printf("r_dash=5.5, val=%e\n", 1-omega(k1,5.5,2,5,dsr1));
	printf("r_dash=6.0, val=%e\n", 1-omega(k1,6.0,2,5,dsr1));
	printf("**********************************\n");

        printf("**************Result 2************\n");
        printf("r_dash=2, val=%e\n", 1-omega(k2,2,5,6,dsr2));
        printf("r_dash=3, val=%e\n", 1-omega(k2,3,4,6,dsr2));
        printf("r_dash=4, val=%e\n", 1-omega(k2,4,3,6,dsr2));
        printf("r_dash=5, val=%e\n", 1-omega(k2,5,2,6,dsr2));
        printf("r_dash=6, val=%e\n", 1-omega(k2,6,2,6,dsr2));
        printf("r_dash=7, val=%e\n", 1-omega(k2,7,2,6,dsr2));
        printf("r_dash=8, val=%e\n", 1-omega(k2,8,2,6,dsr2));
        printf("r_dash=9, val=%e\n", 1-omega(k2,9,2,6,dsr2));
        printf("**********************************\n");

        printf("**************Result 3************\n");
        printf("r_dash=2, val=%e\n", 1-omega(k3,2,5,6,dsr3));
        printf("r_dash=3, val=%e\n", 1-omega(k3,3,4,6,dsr3));
        printf("r_dash=4, val=%e\n", 1-omega(k3,4,3,6,dsr3));
        printf("r_dash=5, val=%e\n", 1-omega(k3,5,2,6,dsr3));
        printf("r_dash=6, val=%e\n", 1-omega(k3,6,2,6,dsr3));
        printf("r_dash=7, val=%e\n", 1-omega(k3,7,2,6,dsr3));
        printf("r_dash=8, val=%e\n", 1-omega(k3,8,2,6,dsr3));
        printf("r_dash=9, val=%e\n", 1-omega(k3,9,2,6,dsr3));
        printf("**********************************\n");
}

