/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: test_path_graph.c,v $
*	$Revision: 1.2 $
*	$Date: 2006/02/12 15:06:31 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Joost-Pieter Katoen, Maneesh Khattri, Ivan Zapreev, Tim Kemna
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: Test the path graph.
*/

# include "path_graph.h"

void print_pg_by_elem(path_graph *pg, int state_id)
{
	path_graph_ele *pge;
	int i, num;

	pge=get_path_graph_ele(pg,state_id);
	num=get_path_graph_num(pg,state_id);
	
	printf("For State %d\n", state_id);
	printf("(R,P)s = {");
	for(i=0;i<num;i++,pge++)
		printf("(%e,%e),",pge->reward,pge->prob);
	printf("}\n");
}

int main()
{
	path_graph *pg=get_new_path_graph(4);

	insert_into_pg(pg, 0, 1, 1);
	insert_into_pg(pg, 0, 1, 1);
	insert_into_pg(pg, 0, 3, 1);
	insert_into_pg(pg, 1, 2, 0.5);
	insert_into_pg(pg, 1, 2, 0.5);
	insert_into_pg(pg, 1, 8, 0.5);
	insert_into_pg(pg, 2, 9, 0.2);
	insert_into_pg(pg, 2, 10, 0.2);
	insert_into_pg(pg, 2, 9, 0.2);
	insert_into_pg(pg, 3, 1, 0.3);
	insert_into_pg(pg, 3, 2, 0.3);
	insert_into_pg(pg, 3, 2, 0.3);
	print_path_graph(pg, 4);
	printf("P(0, 1)=%e\n", get_prob(pg, 0, 1));
	printf("P(0, 3)=%e\n", get_prob(pg, 0, 3));
	printf("P(1, 2)=%e\n", get_prob(pg, 1, 2));
	printf("P(1, 8)=%e\n", get_prob(pg, 1, 8));
	printf("P(2, 9)=%e\n", get_prob(pg, 2, 9));
	printf("P(2, 10)=%e\n", get_prob(pg, 2, 10));
	printf("P(3, 1)=%e\n", get_prob(pg, 3, 1));
	printf("P(3, 2)=%e\n", get_prob(pg, 3, 2));
	
	print_pg_by_elem(pg, 0);
	print_pg_by_elem(pg, 1);
	print_pg_by_elem(pg, 2);
	print_pg_by_elem(pg, 3);

	free_path_graph(pg,4);
}
