/**
*	WARNING: Do Not Remove This Section
*
*	$RCSfile: test_sparse.c,v $
*	$Revision: 1.2 $
*	$Date: 2006/02/12 15:06:31 $
*	$Author: zapreevis $
*	
*	MRMC is a model checker for discrete-time and continuous-time Markov reward models.
*	It supports reward extensions of PCTL and CSL (PRCTL and CSRL), and allows for the
*	automated verification of properties concerning long-run and instantaneous rewards
*	as well as cumulative rewards.
*	
*	Copyright (C) The University of Twente, 2004-2006.
*	Authors: Joost-Pieter Katoen, Maneesh Khattri, Ivan Zapreev, Tim Kemna
*
*	This program is free software; you can redistribute it and/or
*	modify it under the terms of the GNU General Public License
*	as published by the Free Software Foundation; either version 2
*	of the License, or (at your option) any later version.
*
*	This program is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*	GNU General Public License for more details.
*
*	You should have received a copy of the GNU General Public License
*	along with this program; if not, write to the Free Software
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
*	Our contacts:
*		Formal Methods and Tools Group, University of Twente,
*		P.O. Box 217, 7500 AE Enschede, The Netherlands,
*		Phone: +31 53 4893767, Fax: +31 53 4893247,
*		E-mail: mrmc@cs.utwente.nl
*
*	Source description: Tests the sparce matrix structure and some operations on it
*/

# include <malloc.h>
# include "foxglynn.h"
# include "bitset.h"
# include "sparse.h"
# include "string.h"
# include <sys/types.h>

int main(int argc, char *argv[])
{
	int size=0,i;
	double *vec, *res;
	sparse *sp;

	printf("Works for files with the following format: \n");
	printf("No.OfStates\n");
	printf("SrcState DestState Value\n");
	printf("...\n");
	if(argc==3)
	{
		printf("Loading ....\n");
		sp = (sparse *) read_tra_file(argv[1]);
		size = sp->rows;
		set_sparse(sp);
		printf("Loaded matrix:\n");
		print_sparse();

		vec=(double *)malloc(size*sizeof(double));
		res=(double *)malloc(size*sizeof(double));
		for(i=0;i<size;i++)
		{
			vec[i]=2.0;
			res[i]=0.0;
		}

		if(!strcmp(argv[2],"N"))
		{
			printf("Multiply a matrix to a vector\n");
			multiplyMV(vec,res);
		}
		else if(!strcmp(argv[2],"T"))
			{
				printf("Multiply a vector to a matrix\n");
				multiplyTMV(vec,res);
			}
		print_vec_double(size,vec);
		printf("Result: \n");
		print_vec_double(size,res);

	}else{
		printf("FORMAT:: ./sparse input_file.tra\n");
	}
}
